import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.assertion.PublisherAssertion;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.PublisherAssertions;
import org.uddi4j.transport.TransportFactory;
import java.security.Security;
import java.util.Vector;

public class UDDIGetPublisherAssertions1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		AuthToken at = proxy.get_authToken("user", "password");

		PublisherAssertions pas = proxy.get_publisherAssertions(at.getAuthInfoString());

		Vector pav = pas.getPublisherAssertionVector();
		if (pav.size() == 0) {
			System.out.println("no publisher assertion(s) found");
		}
		else {
			System.out.println(pav.size()+" publisher assertion(s) found\n");
			for (int i = 0; i < pav.size(); i++) {
				PublisherAssertion pa = (PublisherAssertion)pav.elementAt(i);
				System.out.println("fromKey : "+pa.getFromKeyString());
				System.out.println("toKey   : "+pa.getToKeyString());
				System.out.println("name    : "+pa.getKeyedReference().getKeyName());
				System.out.println("value   : "+pa.getKeyedReference().getKeyValue());
				System.out.println("\n");
			}
		}
		proxy.discard_authToken(at.getAuthInfo());
	}
}